--script by Phil Stokes / applehelpwriter.com (c)2014
try
    powerstats()
    on error
    display dialog "No internal battery." with title "FastTasks 2" buttons {"OK"} default button "OK" with icon 1
end try

on returnNumbersInString(inputString)
    set s to quoted form of inputString
    do shell script "sed s/[a-zA-Z\\']//g <<< " & s
    set dx to the result
    set numlist to {}
    repeat with i from 1 to count of words in dx
        set this_item to word i of dx
        try
            set this_item to this_item as number
            set the end of numlist to this_item
        end try
    end repeat
    return numlist
end returnNumbersInString

on powerstats()
    do shell script "pmset -g everything | grep Cycles"
    
    set x to result as string
    set nums to returnNumbersInString(x)
    set charging to word 2 of x
    
    if charging contains "Not" then
        set charger to " (not charging!)   ⚠️"
        else
        set charger to " (charging)"
    end if
    
    if text 2 thru 3 of x is "AC" then --power adapter
        set _t to "🕓    Time to Full: "
        set pwr to "AC"
        set source to "🔌    "
        else
        set _t to "🕘    Time Remaining: "
        set pwr to "Batt"
        set source to "==   "
        set charger to ""
    end if
    
    
    
    set percentage to "⚡️    Current charge: " & item 1 of nums & "%"
    set FCC to item 3 of nums as integer
    set des to item 4 of nums as integer
    set health to (FCC / (des / 100))
    set health to round (health)
    set displayHealth to "🍀    Battery Health: " & health & "%"
    set cycles to item -3 of nums
    if item 5 of nums = 0 then
        set hrmins to " mins"
        else
        set hrmins to " hrs"
    end if
    if item 5 of nums is greater than 4 then
        set t to "Calculating...try refresh in 2 mins"
        
        else
        if item 6 of the nums is less than 10 then
            set theMins to item 6 of nums as string
            set theMins to "0" & theMins as string --not proved this works yet
            else
            set theMins to item 6 of nums as integer
        end if
        set t to item 5 of nums & ":" & theMins & hrmins
    end if
    
    if charger contains "(not charging!)   ⚠️" then
        set t to "-- n/a"
    end if
    
    display dialog source & "Power Source: " & pwr & charger & return & percentage & return & _t & t & return & return & displayHealth & return & "🌀    Cycles: " & cycles with title "FastTasks 2" buttons {"Refresh", "OK"} default button "OK" with icon 1
    if button returned of the result is "Refresh" then
        powerstats()
    end if
    
end powerstats
